package tomek.it.graphics;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.DefaultConfiguration;


/*		Structure:  
	JFrame  (BorderLayout)	f
	 +---->  JPanel (GridLayout) [BorderLayout.NORTH]		control
	 |		  +---->  JButton		jbuttonPrevious
  	 |	  	  +---->  JComboBox		jcomboBox
  	 |	  	  +---->  JButton		jbuttonNext
	 +---->  JPanel (CardLayout) [BorderLayout.CENTER]		cards
	  		  +---->  JPanel (FlowLayout)		jpFlag
	  		  +---->  JPanel (FlowLayout)		jpHTML
*/

public class CardPanel01 {
	
	private static final Logger log = LogManager.getLogger(CardPanel01.class);
	
	private final static String c = "Afghanistan, Albania, Argentina, Austria , Belgium, Brazil, Cambodia, Cameroon, Canada, Chile, China, Colombia, Costa Rica, Croatia, Czech Republic, Denmark, Egypt, France, Germany, Hungary, Iceland, India, Indonesia, Iran, Ireland,Israel, Italy, Jamaica, Japan, Kenya, Mexico, Morocco, Nepal, Netherlands, New Zealand,Nigeria, Norway, Peru, Philippines, Poland, Portugal, Romania, Russia, Saudi Arabia,Serbia, Slovakia, South Africa, South Korea, Spain, Sweden, Switzerland, Thailand,Ukraine, United States, Uruguay";
	private final static String f = "Poland";
	
	public final static String COUNTRIES = "countries";
	public final static String FIRST_COUNTRY = "first";
	public final static String countriesProperties = "countries.properties";

	private final static int defaultWidth = 320;
	private final static int defaultHeight = 240;
	
	private final static String[] countries;
	private final static int first;
	
	
	static {
		Configurator.initialize(new DefaultConfiguration());
	    Configurator.setRootLevel(Level.TRACE);
	    
		UIManager.put("ComboBox.selectionForeground", new ColorUIResource(Color.YELLOW));
		
		String cTmp = null, fTmp = null;
		
	    try (FileReader reader = new FileReader(countriesProperties)) {
		    Properties prop = new Properties();
	    	prop.load(reader);
	    	String c1=prop.getProperty(COUNTRIES);
	    	String f1=prop.getProperty(FIRST_COUNTRY);
	    	if (c1==null || c1.isBlank() || f1==null || f1.isBlank()) {
				log.trace("[static]: File: \""+countriesProperties+"\" exists but it looks wrong. Using default settings.");
				log.trace("[static]: File: \""+countriesProperties+"\" will be deleted.");
				try { Files.deleteIfExists(Paths.get(countriesProperties)); }
				catch (Exception e) {
					log.trace("[static]: File: \""+countriesProperties+"\" has not been deleted. "+e.getMessage());					
				}
				cTmp = c;
				fTmp = f;
	    	} 
	    	else {
	    		cTmp=c1;
	    		fTmp=f1;
	    		log.trace("[static]: File: \""+countriesProperties+"\" was processed sucessfully.");	    		
	    	}

	    } catch (FileNotFoundException e) {
			log.trace("[static]: File: \""+countriesProperties+"\" does not exist. Using default settings.");
			
			try (FileWriter writer = new FileWriter(countriesProperties, Charset.forName("UTF8"))) {
			    Properties prop = new Properties();
		    	prop.setProperty(COUNTRIES, cTmp);
		    	prop.setProperty(FIRST_COUNTRY, fTmp);
		    	prop.store(writer, null);
				log.trace("[static]: File: \""+countriesProperties+"\" has been saved sucessfully.");

			} catch (IOException e1) {
				log.trace("[static]: I cannot save default settings to a file : \""+countriesProperties+"\". "+e1.getMessage());
			}			
			
		} catch (IOException e) {
			log.trace("[static]: Problem while reading settongs from file : \""+countriesProperties+"\". Using default settings.");
		}
	    
	    ArrayList<String> tmp = new ArrayList<String>(new TreeSet<String>(List.of(cTmp.split("\s*,\s*"))));
		log.trace("[static]: Found "+tmp.size()+" unique countries: "+tmp);

	    int i = tmp.indexOf(fTmp);
		log.trace("[static]: "+(i<0 ? "Country: \""+fTmp+"\" has not been found - set index: 0" : "Index of the first country ("+fTmp+") is: "+i));

		first=(i<0 ? 0 : i);
		countries = tmp.toArray(new String[0]);
	}
	
	
	
	private static void createAndShowGUI() {
		
		JFrame f = new JFrame("CardLayout DEMO");

		final JPanel control = new JPanel(new GridLayout());
		final JButton jbuttonNext = new JButton();
		final JButton jbuttonPrevious = new JButton();
		final JComboBox<String> jcomboBox = new JComboBox<String>(countries);

		final ImageIcon iiPrevious = new ImageIcon("ICON/arrow-left_red.png");
		final ImageIcon iiNext = new ImageIcon("ICON/arrow-right_red.png");

		final JPanel cards = new JPanel(new CardLayout());
		final String FLAG = "FLAG";
		final String HTML = "HTML";
		final JPanel jpFlag = new JPanel();
		final JPanel jpHTML = new JPanel();
		
		
		ActionListener myActionListener = new ActionListener() {
			
			CardLayout cl = (CardLayout) cards.getLayout();
			int i;
			
			public void actionPerformed(ActionEvent e) {
				i = jcomboBox.getSelectedIndex();
				cl.first(cards);
				log.trace("[ActionListener]: FIRST CARD selected");
				
				if (e.getSource().equals(jbuttonNext)) {
					if (++i == countries.length) i = 0;
					jcomboBox.setSelectedIndex(i);
					log.trace("[ActionListener]: NEXT Button \""+countries[i]+"\" ("+i+")");
					return;
				}
				if (e.getSource().equals(jbuttonPrevious)) {
					if (--i < 0) i = countries.length - 1;
					jcomboBox.setSelectedIndex(i);
					log.trace("[ActionListener]: PREVIOUS Button \""+countries[i]+"\" ("+i+")");
					return;
				}
				log.error("[ActionListener] Unknown object...");
			}
		};

		
		MouseListener myMouseListener = new MouseListener() {

			CardLayout cl = (CardLayout) cards.getLayout();

			public void mouseClicked(MouseEvent e) {}

			public void mousePressed(MouseEvent e) {
				cl.next(cards);
				log.trace("[MouseListener]: Pressed on an object. (NEXT CARD)");
			}

			public void mouseReleased(MouseEvent e) {}

			public void mouseEntered(MouseEvent e) {}

			public void mouseExited(MouseEvent e) {}

		};

		
		jbuttonNext.setIcon(iiNext);
		jbuttonNext.setBorderPainted(false);
		jbuttonNext.setContentAreaFilled(false);
		jbuttonNext.setBorder(null);
		jbuttonNext.setFocusPainted(false);
		jbuttonNext.setMargin(new Insets(0, 0, 0, 0));
		jbuttonNext.addActionListener(myActionListener);

		jbuttonPrevious.setIcon(iiPrevious);
		jbuttonPrevious.setBorderPainted(false);
		jbuttonPrevious.setContentAreaFilled(false);
		jbuttonPrevious.setBorder(null);
		jbuttonPrevious.setFocusPainted(false);
		jbuttonPrevious.setMargin(new Insets(0, 0, 0, 0));
		jbuttonPrevious.addActionListener(myActionListener);

		jcomboBox.setBackground(Color.LIGHT_GRAY);
		jcomboBox.setForeground(Color.BLUE);
		jcomboBox.setFont(new Font("Verdana", Font.BOLD, 12));

		// JPanel - control
		control.setBackground(Color.DARK_GRAY);

		control.add(jbuttonPrevious);
		control.add(jcomboBox);
		control.add(jbuttonNext);

		// JPanel - main
		jpFlag.setPreferredSize(new Dimension(defaultWidth, defaultHeight));
		jpFlag.setBackground(Color.DARK_GRAY);
		jpFlag.addMouseListener(myMouseListener);
		jpFlag.setName(FLAG);

		jpHTML.setPreferredSize(new Dimension(defaultWidth, defaultHeight));
		jpHTML.setBackground(Color.DARK_GRAY);
		jpHTML.addMouseListener(myMouseListener);
		jpHTML.setName(HTML);

		
		ItemListener myItemListener = new ItemListener() {
			public void itemStateChanged(ItemEvent ie) {
				if (ie.getStateChange()==ItemEvent.SELECTED) {
					log.trace("[ItemListener]: "+ ie.paramString());
				}
			}
		};

		jcomboBox.addItemListener(myItemListener);
		jcomboBox.setSelectedIndex(first);

		cards.add(jpFlag);
		cards.add(jpHTML);

		f.add(cards, BorderLayout.CENTER);
		f.add(control, BorderLayout.NORTH);

		f.pack();
		f.setLocationRelativeTo(null);
		f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		f.setVisible(true);
	}
	
	
	public static void main(String[] args) {
		
		javax.swing.SwingUtilities.invokeLater(new Runnable() {
			public void run() {
					createAndShowGUI();
			}
		});
	}

}
